/*
 *  radiusplugin -- An OpenVPN plugin for do radius authentication 
 *					and accounting.
 * 
 *  Copyright (C) 2005 EWE TEL GmbH/Ralf Luebben <ralfluebben@gmx.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#ifndef _USER_H_
#define _USER_H_
#include <string>
#include <iostream>
#include <stdio.h>
#include "openvpn-plugin.h"


/** The datatype for sending and receiving data to and from the network */ 
typedef	unsigned char	Octet;



using namespace std;

/** The user class represents a general user for the three different processes (foreground,
 * authentication background, accounting background). Here are defined the
 * common attributes and functions.*/

class User
{
protected:
	string username;			/**<The username.*/
	string commonname;			/**<The commonname.*/
	string framedroutes;		/**<The framedroutes, they are stored as a string. if there are more routes, they must be delimted by an ';'*/
	string framedip;			/**<The framed ip.*/
	string callingstationid;	/**<The calling station id, in this case the real ip addres of the client.*/
	string key;					/**<A unique key to find the user in a map. It is the same like the unique identifier in the status log file (version 1) "commonname,untrusted_ip:untrusted_port"*/
	int portnumber;				/**<The portnumber.*/
	time_t acctinteriminterval;	/**<The acct interim interval.*/
	string untrustedport;		/**<The untrusted port number from OpenVPN for a client.*/
	Octet * vsabuf; 			/**<Buffer for all VSA attributes.*/
	unsigned int vsabuflen; 	/**<Length of vsabuf.*/
	
public:
	User();
	//User(int);
	~User();
	
	User & operator=(const User &);
	User(const User &);
	
	string getUsername(void);
	void setUsername(string);
	
	string getCommonname(void);
	void setCommonname(string);
		
	
	string getFramedRoutes(void);
	void setFramedRoutes(string);
	
	string getFramedIp(void);
	void setFramedIp(string);
	
	string getKey(void);
	void setKey(string);
	
	string getCallingStationId(void);
	void setCallingStationId(string);
	
	int getPortnumber(void);
	void setPortnumber(int);
	
	time_t getAcctInterimInterval(void);
	void setAcctInterimInterval(time_t);
			
	string getUntrustedPort(void);
	void setUntrustedPort(string);
	
	int appendVsaBuf(Octet *, unsigned int len);
	Octet * getVsaBuf();
	void setVsaBuf(Octet *);
	
	unsigned int getVsaBufLen();
	void setVsaBufLen(unsigned int);
	
	
	
};

#endif //_USER_H_
