/* All Rights reserved */

#import "Document.h"

@implementation Document

- (id) init
{
  self = [super init];
  records = [NSMutableArray new];
  return self;
}

- (void) dealloc
{
  RELEASE(records);
  [super dealloc];
}

- (void) windowControllerDidLoadNib: (NSWindowController *) controller
{
  NSTableColumn *column;
  NSArray *columns = [tableView tableColumns];

  column = [columns objectAtIndex: 0];
  [column setWidth: 100];
  [column setEditable: YES];
  [column setResizable: YES];
  [column setIdentifier: @"date"];
  [[column headerCell] setStringValue: @"Date"];

  column = [columns objectAtIndex: 1];
  [column setWidth: 100];
  [column setEditable: YES];
  [column setResizable: YES];
  [column setIdentifier: @"item"];
  [[column headerCell] setStringValue: @"Item"];

  column = [[NSTableColumn alloc] initWithIdentifier: @"amount"];
  [column setWidth: 100];
  [column setEditable: YES];
  [column setResizable: YES];
  [[column headerCell] setStringValue: @"Amount"];
  [tableView addTableColumn: column];
  RELEASE(column);

  [tableView sizeLastColumnToFit];
  [tableView setAutoresizesAllColumnsToFit: YES];
}

- (int) numberOfRowsInTableView: (NSTableView *) view
{
  return [records count] + 1;
}

- (id) tableView: (NSTableView *) view
       objectValueForTableColumn: (NSTableColumn *) column
      row: (int) row
{
  if (row >= [records count])
    {
      return @"";
    }
  else
    {
      return [[records objectAtIndex: row] objectForKey: [column identifier]];
    }
}

- (void) tableView: (NSTableView *) view
       setObjectValue: (id) object
       forTableColumn: (NSTableColumn *) column
       row: (int) row
{
  if (row >= [records count])
    {
      [records addObject: [NSMutableDictionary new]];
    }
  [[records objectAtIndex: row] setObject: object
                                   forKey: [column identifier]];
  [tableView reloadData];
} 

- (NSString *) windowNibName
{
  return @"Document.gorm";
}

@end
